/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.Rules;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNestedPropertiesRule
extends Rule {
    private Log log = null;
    private boolean trimData = true;
    private boolean allowUnknownChildElements = false;
    private HashMap<String, String> elementNames = new HashMap();

    public SetNestedPropertiesRule() {
    }

    public SetNestedPropertiesRule(String elementName, String propertyName) {
        this.elementNames.put(elementName, propertyName);
    }

    public SetNestedPropertiesRule(String[] elementNames, String[] propertyNames) {
        int size = elementNames.length;
        for (int i = 0; i < size; ++i) {
            String propName = null;
            if (i < propertyNames.length) {
                propName = propertyNames[i];
            }
            this.elementNames.put(elementNames[i], propName);
        }
    }

    public SetNestedPropertiesRule(Map<String, String> elementNames) {
        if (elementNames != null && !elementNames.isEmpty()) {
            this.elementNames.putAll(elementNames);
        }
    }

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        this.log = digester.getLogger();
    }

    public void setTrimData(boolean trimData) {
        this.trimData = trimData;
    }

    public boolean getTrimData() {
        return this.trimData;
    }

    public void setAllowUnknownChildElements(boolean allowUnknownChildElements) {
        this.allowUnknownChildElements = allowUnknownChildElements;
    }

    public boolean getAllowUnknownChildElements() {
        return this.allowUnknownChildElements;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Rules oldRules = this.getDigester().getRules();
        AnyChildRule anyChildRule = new AnyChildRule();
        anyChildRule.setDigester(this.getDigester());
        AnyChildRules newRules = new AnyChildRules(anyChildRule);
        newRules.init(this.getDigester().getMatch() + "/", oldRules);
        this.getDigester().setRules(newRules);
    }

    @Override
    public void body(String namespace, String name, String text) throws Exception {
        AnyChildRules newRules = (AnyChildRules)this.getDigester().getRules();
        this.getDigester().setRules(newRules.getOldRules());
    }

    public void addAlias(String elementName, String propertyName) {
        this.elementNames.put(elementName, propertyName);
    }

    public String toString() {
        return String.format("SetNestedPropertiesRule[allowUnknownChildElements=%s, trimData=%s, elementNames=%s]", this.allowUnknownChildElements, this.trimData, this.elementNames);
    }

    private class AnyChildRule
    extends Rule {
        private String currChildElementName = null;

        private AnyChildRule() {
        }

        public void begin(String namespaceURI, String name, Attributes attributes) throws Exception {
            this.currChildElementName = name;
        }

        public void body(String namespace, String name, String text) throws Exception {
            Object desc;
            String propName = this.currChildElementName;
            if (SetNestedPropertiesRule.this.elementNames.containsKey(this.currChildElementName) && (propName = (String)SetNestedPropertiesRule.this.elementNames.get(this.currChildElementName)) == null) {
                return;
            }
            boolean debug = SetNestedPropertiesRule.this.log.isDebugEnabled();
            if (debug) {
                SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.getDigester().getMatch() + "} Setting property '" + propName + "' to '" + text + "'");
            }
            Object top = this.getDigester().peek();
            if (debug) {
                if (top != null) {
                    SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.getDigester().getMatch() + "} Set " + top.getClass().getName() + " properties");
                } else {
                    SetNestedPropertiesRule.this.log.debug("[SetPropertiesRule]{" + this.getDigester().getMatch() + "} Set NULL properties");
                }
            }
            if (SetNestedPropertiesRule.this.trimData) {
                text = text.trim();
            }
            if (!SetNestedPropertiesRule.this.allowUnknownChildElements && (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(propName)) == null : (desc = PropertyUtils.getPropertyDescriptor(top, propName)) == null)) {
                throw new NoSuchMethodException("Bean has no property named " + propName);
            }
            try {
                BeanUtils.setProperty(top, propName, text);
            }
            catch (NullPointerException e) {
                SetNestedPropertiesRule.this.log.error("NullPointerException: top=" + top + ",propName=" + propName + ",value=" + text + "!");
                throw e;
            }
        }

        public void end(String namespace, String name) throws Exception {
            this.currChildElementName = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnyChildRules
    implements Rules {
        private String matchPrefix = null;
        private Rules decoratedRules = null;
        private ArrayList<Rule> rules = new ArrayList(1);
        private AnyChildRule rule;

        public AnyChildRules(AnyChildRule rule) {
            this.rule = rule;
            this.rules.add(rule);
        }

        @Override
        public Digester getDigester() {
            return null;
        }

        @Override
        public void setDigester(Digester digester) {
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public void setNamespaceURI(String namespaceURI) {
        }

        @Override
        public void add(String pattern, Rule rule) {
        }

        @Override
        public void clear() {
        }

        @Override
        public List<Rule> match(String namespaceURI, String matchPath, String name, Attributes attributes) {
            List<Rule> match = this.decoratedRules.match(namespaceURI, matchPath, name, attributes);
            if (matchPath.startsWith(this.matchPrefix) && matchPath.indexOf(47, this.matchPrefix.length()) == -1) {
                if (match == null || match.size() == 0) {
                    return this.rules;
                }
                LinkedList<Rule> newMatch = new LinkedList<Rule>(match);
                newMatch.addLast(this.rule);
                return newMatch;
            }
            return match;
        }

        @Override
        public List<Rule> rules() {
            SetNestedPropertiesRule.this.log.debug("AnyChildRules.rules invoked.");
            return this.decoratedRules.rules();
        }

        public void init(String prefix, Rules rules) {
            this.matchPrefix = prefix;
            this.decoratedRules = rules;
        }

        public Rules getOldRules() {
            return this.decoratedRules;
        }
    }
}

