/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.rat.config.exclusion.plexus.SelectorUtils;
import org.apache.rat.document.DocumentName;
import org.apache.rat.utils.ExtendedIterator;

@FunctionalInterface
public interface FileProcessor
extends Function<DocumentName, List<String>> {
    public static final String REGEX_FMT = "%%regex[%s]";
    public static final FileProcessor EMPTY = DocumentName2 -> Collections.emptyList();

    public static FileProcessor from(Iterable<String> patterns) {
        return documentName -> ExtendedIterator.create(patterns.iterator()).map(entry -> FileProcessor.localizePattern(documentName, entry)).map(DocumentName::getName).addTo(new ArrayList());
    }

    default public String modifyEntry(DocumentName documentName, String entry) {
        return entry;
    }

    public static DocumentName localizePattern(DocumentName baseName, String pattern) {
        boolean prefix = pattern.startsWith("!");
        String workingPattern = prefix ? pattern.substring(1) : pattern;
        String normalizedPattern = SelectorUtils.extractPattern(workingPattern, baseName.getDirectorySeparator());
        StringBuilder sb = new StringBuilder(prefix ? "!" : "");
        if (SelectorUtils.isRegexPrefixedPattern(workingPattern)) {
            sb.append("%regex[").append("\\Q").append(baseName.getBaseName()).append(baseName.getDirectorySeparator()).append("\\E").append(normalizedPattern).append("]");
        } else {
            sb.append(baseName.getBaseName()).append(baseName.getDirectorySeparator()).append(normalizedPattern);
        }
        return new DocumentName(sb.toString(), baseName.getBaseName(), baseName.getDirectorySeparator(), baseName.isCaseSensitive());
    }
}

