/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.EnvironmentConvertibleValuesMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class EnvironmentAnnotationValue<A extends Annotation>
extends AnnotationValue<A> {
    private final Environment environment;

    EnvironmentAnnotationValue(Environment environment2, AnnotationValue<A> target) {
        super(target, AnnotationMetadataSupport.getDefaultValues(target.getAnnotationName()), EnvironmentConvertibleValuesMap.of(environment2, target.getValues()), environment2 != null ? o -> {
            PropertyPlaceholderResolver resolver = environment2.getPlaceholderResolver();
            if (o instanceof String) {
                String v = (String)o;
                if (v.contains(resolver.getPrefix())) {
                    return resolver.resolveRequiredPlaceholders(v);
                }
            } else if (o instanceof String[]) {
                String[] values = (String[])o;
                String[] resolvedValues = Arrays.copyOf(values, values.length);
                boolean expandValues = false;
                for (int i2 = 0; i2 < values.length; ++i2) {
                    String value = values[i2];
                    if (value.contains(resolver.getPrefix()) && (value = resolver.resolveRequiredPlaceholders(value)).contains(",")) {
                        expandValues = true;
                    }
                    resolvedValues[i2] = value;
                }
                if (expandValues) {
                    return Stream.of(resolvedValues).flatMap(s -> {
                        if (s.contains(",")) {
                            return Arrays.stream(resolver.resolveRequiredPlaceholder((String)s, String[].class));
                        }
                        return Stream.of(s);
                    }).toArray(String[]::new);
                }
                return resolvedValues;
            }
            return o;
        } : null);
        this.environment = environment2;
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member, Class<T> type) {
        List<AnnotationValue<T>> annotationValues = super.getAnnotations(member, type);
        return annotationValues.stream().map(av -> new EnvironmentAnnotationValue<A>(this.environment, av)).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member) {
        List annotationValues = super.getAnnotations(member);
        return annotationValues.stream().map(av -> new EnvironmentAnnotationValue<A>(this.environment, av)).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(String member, Class<T> type) {
        Optional<AnnotationValue<AnnotationValue>> annotationValue = super.getAnnotation(member, type);
        return annotationValue.map(av -> new EnvironmentAnnotationValue<A>(this.environment, av));
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(@NonNull String member) {
        Optional<AnnotationValue<AnnotationValue>> annotationValue = super.getAnnotation(member);
        return annotationValue.map(av -> new EnvironmentAnnotationValue<A>(this.environment, av));
    }
}

