/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class SystemProperties {
    private static final Set<String> STANDARD_PROPERTIES;
    private static final Set<String> IMPORTANT_NON_STANDARD_PROPERTIES;
    private static final SystemProperties INSTANCE;

    public static SystemProperties getInstance() {
        return INSTANCE;
    }

    private SystemProperties() {
    }

    public String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    @Deprecated
    public String getJavaIoTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getUserHome() {
        return System.getProperty("user.home");
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public File getCurrentDir() {
        return new File(System.getProperty("user.dir"));
    }

    @Nullable
    public String getWorkerTmpDir() {
        return System.getProperty("org.gradle.internal.worker.tmpdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T withSystemProperty(String propertyName, String value, Factory<T> factory) {
        String originalValue = this.overrideProperty(propertyName, value);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.restoreProperty(propertyName, originalValue);
        }
    }

    public synchronized <T> T withSystemProperties(Factory<T> factory) {
        return factory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T withSystemProperties(Map<String, String> properties, Factory<T> factory) {
        String originalValue;
        HashMap<String, String> originalProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            String value = property.getValue();
            originalValue = this.overrideProperty(propertyName, value);
            originalProperties.put(propertyName, originalValue);
        }
        try {
            Iterator<Map.Entry<String, String>> iterator = factory.create();
            return (T)iterator;
        }
        finally {
            for (Map.Entry property : originalProperties.entrySet()) {
                String propertyName = (String)property.getKey();
                originalValue = (String)property.getValue();
                this.restoreProperty(propertyName, originalValue);
            }
        }
    }

    @Nullable
    private String overrideProperty(String propertyName, String value) {
        String originalValue = System.getProperty(propertyName);
        if (value != null) {
            System.setProperty(propertyName, value);
        } else {
            System.clearProperty(propertyName);
        }
        return originalValue;
    }

    private void restoreProperty(String propertyName, @Nullable String originalValue) {
        if (originalValue != null) {
            System.setProperty(propertyName, originalValue);
        } else {
            System.clearProperty(propertyName);
        }
    }

    public boolean isStandardProperty(String key) {
        return STANDARD_PROPERTIES.contains(key);
    }

    public boolean isNonStandardImportantProperty(String key) {
        return IMPORTANT_NON_STANDARD_PROPERTIES.contains(key);
    }

    static {
        HashSet<String> standardProperties = new HashSet<String>();
        standardProperties.add("java.version");
        standardProperties.add("java.vendor");
        standardProperties.add("java.vendor.url");
        standardProperties.add("java.home");
        standardProperties.add("java.vm.specification.version");
        standardProperties.add("java.vm.specification.vendor");
        standardProperties.add("java.vm.specification.name");
        standardProperties.add("java.vm.version");
        standardProperties.add("java.vm.vendor");
        standardProperties.add("java.vm.name");
        standardProperties.add("java.specification.version");
        standardProperties.add("java.specification.vendor");
        standardProperties.add("java.specification.name");
        standardProperties.add("java.class.version");
        standardProperties.add("java.class.path");
        standardProperties.add("java.library.path");
        standardProperties.add("java.io.tmpdir");
        standardProperties.add("java.compiler");
        standardProperties.add("java.ext.dirs");
        standardProperties.add("os.name");
        standardProperties.add("os.arch");
        standardProperties.add("os.version");
        standardProperties.add("file.separator");
        standardProperties.add("path.separator");
        standardProperties.add("line.separator");
        standardProperties.add("user.name");
        standardProperties.add("user.home");
        standardProperties.add("user.dir");
        STANDARD_PROPERTIES = Collections.unmodifiableSet(standardProperties);
        IMPORTANT_NON_STANDARD_PROPERTIES = Collections.singleton("java.runtime.version");
        INSTANCE = new SystemProperties();
    }
}

