/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.micronaut;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.PomDependencyVersionResolver;
import org.grails.forge.feature.Feature;

@Singleton
public class MicronautHttpClient
implements Feature {
    private final PomDependencyVersionResolver versionResolver;

    public MicronautHttpClient(PomDependencyVersionResolver versionResolver) {
        this.versionResolver = versionResolver;
    }

    @Override
    @NonNull
    public String getName() {
        return "micronaut-http-client";
    }

    @Override
    public String getTitle() {
        return "Micronaut HTTP Client";
    }

    @Override
    public String getDescription() {
        return "Add support for the Micronaut HTTP client.";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public String getCategory() {
        return "Client";
    }

    @Override
    public String getDocumentation() {
        return "https://docs.micronaut.io/latest/guide/index.html#httpClient";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        Optional<Coordinate> micronautPlatformVersion = this.versionResolver.resolve("micronaut-platform");
        micronautPlatformVersion.ifPresent(coordinate -> generatorContext.getBuildProperties().put("micronautPlatformVersion", coordinate.getVersion()));
        generatorContext.addDependency(Dependency.builder().groupId("io.micronaut.platform").artifactId("micronaut-platform").pom(true).version("$micronautPlatformVersion").implementation().build());
        generatorContext.addDependency(Dependency.builder().groupId("io.micronaut").artifactId("micronaut-http-client").implementation());
        generatorContext.addDependency(Dependency.builder().groupId("io.micronaut.serde").artifactId("micronaut-serde-jackson").implementation());
    }
}

