/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.definition;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.swagger.invocation.InvocationType;

public final class ProtobufManager {
    public static final String EXT_ID = "protobuf";
    private static final Object LOCK = new Object();
    private static final Map<RuntimeCacheKey, OperationProtobuf> RUNTIME_CACHE = new HashMap<RuntimeCacheKey, OperationProtobuf>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationProtobuf getOrCreateOperation(Invocation invocation) {
        RuntimeCacheKey cacheKey = new RuntimeCacheKey(invocation.getInvocationType(), invocation.getOperationMeta().getMicroserviceQualifiedName(), invocation.findResponseType(Response.Status.OK.getStatusCode()));
        OperationProtobuf operationProtobuf = RUNTIME_CACHE.get(cacheKey);
        if (operationProtobuf == null) {
            Object object = LOCK;
            synchronized (object) {
                MicroserviceMeta microserviceMeta = invocation.getMicroserviceMeta();
                ScopedProtobufSchemaManager scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(EXT_ID);
                if (scopedProtobufSchemaManager == null) {
                    scopedProtobufSchemaManager = new ScopedProtobufSchemaManager();
                    microserviceMeta.putExtData(EXT_ID, (Object)scopedProtobufSchemaManager);
                }
                if ((operationProtobuf = RUNTIME_CACHE.get(cacheKey)) == null) {
                    operationProtobuf = new OperationProtobuf(scopedProtobufSchemaManager, invocation);
                    RUNTIME_CACHE.put(cacheKey, operationProtobuf);
                }
            }
        }
        return operationProtobuf;
    }

    @VisibleForTesting
    public static void clear() {
        RUNTIME_CACHE.clear();
    }

    static class RuntimeCacheKey {
        final InvocationType invocationType;
        final String uniqueOperationId;
        final JavaType responseType;

        public RuntimeCacheKey(InvocationType invocationType, String operationId, JavaType responseType) {
            this.invocationType = invocationType;
            this.uniqueOperationId = operationId;
            this.responseType = responseType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuntimeCacheKey that = (RuntimeCacheKey)o;
            if (this.invocationType != that.invocationType) {
                return false;
            }
            if (!this.uniqueOperationId.equals(that.uniqueOperationId)) {
                return false;
            }
            return Objects.equals(this.responseType, that.responseType);
        }

        public int hashCode() {
            int result = this.invocationType.hashCode();
            result = 31 * result + this.uniqueOperationId.hashCode();
            result = 31 * result + (this.responseType != null ? this.responseType.hashCode() : 0);
            return result;
        }
    }
}

