/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.Client;
import org.springframework.webflow.execution.RequestContext;

public interface DelegatedClientIdentityProviderAuthorizer {
    default public boolean isDelegatedClientAuthorizedForService(Client client, Service service, HttpServletRequest context) {
        return this.isDelegatedClientAuthorizedFor(client.getName(), service, context);
    }

    default public boolean isDelegatedClientAuthorizedForService(Client client, Service service, RequestContext context) {
        return this.isDelegatedClientAuthorizedFor(client.getName(), service, context);
    }

    default public boolean isDelegatedClientAuthorizedForAuthentication(Authentication authentication, Service service, RequestContext context) {
        String clientName = this.getClientNameFromAuthentication(authentication);
        return this.isDelegatedClientAuthorizedFor(clientName, service, context);
    }

    default public String getClientNameFromAuthentication(Authentication authentication) {
        List clientNames = authentication.getAttributes().getOrDefault("clientName", new ArrayList(0));
        return CollectionUtils.firstElement((Object)clientNames).map(Object::toString).orElse("");
    }

    public boolean isDelegatedClientAuthorizedFor(String var1, Service var2, RequestContext var3);

    public boolean isDelegatedClientAuthorizedFor(String var1, Service var2, HttpServletRequest var3);
}

