/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ExternalRedirectAction
extends AbstractAction {
    private Expression resourceUri;

    public ExternalRedirectAction(Expression resourceUri) {
        Assert.notNull((Object)resourceUri, (String)"The URI of the resource to redirect to is required");
        this.resourceUri = resourceUri;
    }

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        String resourceUri = (String)this.resourceUri.getValue((Object)context);
        context.getExternalContext().requestExternalRedirect(resourceUri);
        return this.success();
    }
}

