/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.foedus.util.StreamUtils;
import com.icegreen.greenmail.pop3.Pop3Handler;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.InternetPrintWriter;
import com.icegreen.greenmail.util.LoggingInputStream;
import com.icegreen.greenmail.util.LoggingOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3Connection {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    Pop3Handler handler;
    Socket socket;
    InetAddress clientAddress;
    BufferedReader in;
    InternetPrintWriter out;

    public Pop3Connection(Pop3Handler handler, Socket socket) throws IOException {
        this.configureSocket(socket);
        this.configureStreams();
        this.handler = handler;
    }

    private void configureStreams() throws IOException {
        OutputStream o = this.socket.getOutputStream();
        if (this.log.isDebugEnabled()) {
            o = new LoggingOutputStream(o, "S: ");
        }
        this.out = InternetPrintWriter.createForEncoding(o, true, EncodingUtil.CHARSET_EIGHT_BIT_ENCODING);
        InputStream i = this.socket.getInputStream();
        if (this.log.isDebugEnabled()) {
            i = new LoggingInputStream(i, "C: ");
        }
        this.in = new BufferedReader(new InputStreamReader(i));
    }

    private void configureSocket(Socket socket) {
        this.socket = socket;
        this.clientAddress = this.socket.getInetAddress();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void quit() {
        this.handler.close();
    }

    public void println(String line) {
        this.out.print(line);
        this.println();
    }

    public void println() {
        this.out.print("\r\n");
        this.out.flush();
    }

    public void print(String line) {
        this.out.print(line);
    }

    public void print(Reader in) throws IOException {
        StreamUtils.copy(in, this.out);
        this.out.flush();
    }

    public void println(Reader in) throws IOException {
        StreamUtils.copy(in, this.out);
        this.println();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public String getClientAddress() {
        return this.clientAddress.toString();
    }
}

