/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.cas.validation.ImmutableAssertion;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="releaseAttributes", enableByDefault=false)
public class CasReleaseAttributesReportEndpoint
extends BaseCasActuatorEndpoint {
    private final ServicesManager servicesManager;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServiceFactory<WebApplicationService> serviceFactory;
    private final PrincipalFactory principalFactory;

    public CasReleaseAttributesReportEndpoint(CasConfigurationProperties casProperties, ServicesManager servicesManager, AuthenticationSystemSupport authenticationSystemSupport, ServiceFactory<WebApplicationService> serviceFactory, PrincipalFactory principalFactory) {
        super(casProperties);
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
    }

    @ReadOperation
    @Operation(summary="Get collection of released attributes for the user and application", parameters={@Parameter(name="username", required=true), @Parameter(name="password", required=true), @Parameter(name="service", required=true)})
    public Map<String, Object> releasePrincipalAttributes(String username, String password, String service) {
        WebApplicationService selectedService = (WebApplicationService)this.serviceFactory.createService(service);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)selectedService);
        UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
        AuthenticationResult result = this.authenticationSystemSupport.finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
        Authentication authentication = result.getAuthentication();
        Principal principal = authentication.getPrincipal();
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service((Service)selectedService).principal(principal).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((Principal)principal, (PrincipalFactory)this.principalFactory, (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
        Authentication finalAuthentication = builder.build();
        Assertion assertion = DefaultAssertionBuilder.builder().primaryAuthentication(finalAuthentication).service(selectedService).authentications(CollectionUtils.wrap((Object)finalAuthentication)).registeredService(registeredService).build().assemble();
        LinkedHashMap<String, Object> resValidation = new LinkedHashMap<String, Object>();
        resValidation.put("assertion", assertion);
        resValidation.put("service", selectedService);
        resValidation.put("registeredService", registeredService);
        return resValidation;
    }

    @WriteOperation
    @Operation(summary="Get collection of released attributes for the user and application", parameters={@Parameter(name="username", required=true), @Parameter(name="password", required=true), @Parameter(name="service", required=true)})
    public Map<String, Object> releaseAttributes(String username, String password, String service) {
        Map<String, Object> map = this.releasePrincipalAttributes(username, password, service);
        ImmutableAssertion assertion = (ImmutableAssertion)map.get("assertion");
        return Map.of("uid", username, "attributes", assertion.getPrimaryAuthentication().getPrincipal().getAttributes());
    }
}

