/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.authprofiles;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.authprofiles.AuthProfileItemDirectoryPanel;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalDirectoryPanel;
import org.apache.syncope.client.console.rest.AuthProfileRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanConditionColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.common.lib.wa.U2FDevice;
import org.apache.syncope.common.lib.wa.WebAuthnDeviceCredential;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class AuthProfileDirectoryPanel
extends DirectoryPanel<AuthProfileTO, AuthProfileTO, AuthProfileProvider, AuthProfileRestClient> {
    private static final long serialVersionUID = 2018518567549153364L;
    private final BaseModal<AuthProfileTO> authProfileModal = new BaseModal<AuthProfileTO>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };

    public AuthProfileDirectoryPanel(String id, AuthProfileRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.authProfileModal.size(Modal.Size.Large);
        this.authProfileModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.authProfileModal.show(false);
        });
        this.addOuterObject(new Component[]{this.authProfileModal});
        this.disableCheckBoxes();
        this.initResultTable();
    }

    protected AuthProfileProvider dataProvider() {
        return new AuthProfileProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "authprofile.paginator.rows";
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected List<IColumn<AuthProfileTO, String>> getColumns() {
        ArrayList<IColumn<AuthProfileTO, String>> columns = new ArrayList<IColumn<AuthProfileTO, String>>();
        columns.add((IColumn<AuthProfileTO, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<AuthProfileTO, String>)new PropertyColumn((IModel)new ResourceModel("owner"), (Object)"owner", "owner"));
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("impersonationAccounts")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getImpersonationAccounts());
            }
        });
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("googleMfaAuthTokens")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getGoogleMfaAuthTokens());
            }
        });
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("googleMfaAuthAccounts")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getGoogleMfaAuthAccounts());
            }
        });
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("u2fRegisteredDevices")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getU2FRegisteredDevices());
            }
        });
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("mfaTrustedDevices")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getMfaTrustedDevices());
            }
        });
        columns.add((IColumn<AuthProfileTO, String>)new BooleanConditionColumn<AuthProfileTO>((IModel)new StringResourceModel("webAuthnAccount")){
            private static final long serialVersionUID = -8236820422411536323L;

            protected boolean isCondition(IModel<AuthProfileTO> rowModel) {
                return CollectionUtils.isNotEmpty((Collection)((AuthProfileTO)rowModel.getObject()).getWebAuthnDeviceCredentials());
            }
        });
        return columns;
    }

    public ActionsPanel<AuthProfileTO> getActions(final IModel<AuthProfileTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<ImpersonationAccount>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -5380664539000792237L;

                    @Override
                    protected List<ImpersonationAccount> getItems() {
                        return ((AuthProfileTO)model.getObject()).getImpersonationAccounts();
                    }

                    @Override
                    protected ImpersonationAccount defaultItem() {
                        return new ImpersonationAccount();
                    }

                    @Override
                    protected String sortProperty() {
                        return "impersonated";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.impersonated.paginator.rows";
                    }

                    protected List<IColumn<ImpersonationAccount, String>> getColumns() {
                        ArrayList<IColumn<ImpersonationAccount, String>> columns = new ArrayList<IColumn<ImpersonationAccount, String>>();
                        columns.add((IColumn<ImpersonationAccount, String>)new PropertyColumn((IModel)new ResourceModel("impersonated"), (Object)"impersonated", "impersonated"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("impersonationAccounts", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<GoogleMfaAuthToken>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = 7332357430197837993L;

                    @Override
                    protected List<GoogleMfaAuthToken> getItems() {
                        return ((AuthProfileTO)model.getObject()).getGoogleMfaAuthTokens();
                    }

                    @Override
                    protected GoogleMfaAuthToken defaultItem() {
                        return new GoogleMfaAuthToken();
                    }

                    @Override
                    protected String sortProperty() {
                        return "issueDate";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.googlemfaauthtokens.paginator.rows";
                    }

                    protected List<IColumn<GoogleMfaAuthToken, String>> getColumns() {
                        ArrayList<IColumn<GoogleMfaAuthToken, String>> columns = new ArrayList<IColumn<GoogleMfaAuthToken, String>>();
                        columns.add((IColumn<GoogleMfaAuthToken, String>)new DatePropertyColumn((IModel)new ResourceModel("issueDate"), "issueDate", "issueDate"));
                        columns.add((IColumn<GoogleMfaAuthToken, String>)new PropertyColumn((IModel)new ResourceModel("otp"), (Object)"otp", "otp"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("googleMfaAuthTokens", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.EDIT_APPROVAL, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<GoogleMfaAuthAccount>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -670769282358547044L;

                    @Override
                    protected List<GoogleMfaAuthAccount> getItems() {
                        return ((AuthProfileTO)model.getObject()).getGoogleMfaAuthAccounts();
                    }

                    @Override
                    protected GoogleMfaAuthAccount defaultItem() {
                        return new GoogleMfaAuthAccount();
                    }

                    @Override
                    protected String sortProperty() {
                        return "id";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.googlemfaauthaccounts.paginator.rows";
                    }

                    protected List<IColumn<GoogleMfaAuthAccount, String>> getColumns() {
                        ArrayList<IColumn<GoogleMfaAuthAccount, String>> columns = new ArrayList<IColumn<GoogleMfaAuthAccount, String>>();
                        columns.add((IColumn<GoogleMfaAuthAccount, String>)new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
                        columns.add((IColumn<GoogleMfaAuthAccount, String>)new DatePropertyColumn((IModel)new ResourceModel("registrationDate"), "registrationDate", "registrationDate"));
                        columns.add((IColumn<GoogleMfaAuthAccount, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("googleMfaAuthAccounts", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.EXECUTE, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<U2FDevice>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = 5788448799796630011L;

                    @Override
                    protected List<U2FDevice> getItems() {
                        return ((AuthProfileTO)model.getObject()).getU2FRegisteredDevices();
                    }

                    @Override
                    protected U2FDevice defaultItem() {
                        return new U2FDevice();
                    }

                    @Override
                    protected String sortProperty() {
                        return "id";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.u2fdevices.paginator.rows";
                    }

                    protected List<IColumn<U2FDevice, String>> getColumns() {
                        ArrayList<IColumn<U2FDevice, String>> columns = new ArrayList<IColumn<U2FDevice, String>>();
                        columns.add((IColumn<U2FDevice, String>)new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
                        columns.add((IColumn<U2FDevice, String>)new DatePropertyColumn((IModel)new ResourceModel("issueDate"), "issueDate", "issueDate"));
                        columns.add((IColumn<U2FDevice, String>)new PropertyColumn((IModel)new ResourceModel("record"), (Object)"record", "record"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("u2fRegisteredDevices", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.DEPROVISION, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<MfaTrustedDevice>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = 5788448799796630011L;

                    @Override
                    protected List<MfaTrustedDevice> getItems() {
                        return ((AuthProfileTO)model.getObject()).getMfaTrustedDevices();
                    }

                    @Override
                    protected MfaTrustedDevice defaultItem() {
                        return new MfaTrustedDevice();
                    }

                    @Override
                    protected String sortProperty() {
                        return "id";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.mfaTrustedDevices.paginator.rows";
                    }

                    protected List<IColumn<MfaTrustedDevice, String>> getColumns() {
                        ArrayList<IColumn<MfaTrustedDevice, String>> columns = new ArrayList<IColumn<MfaTrustedDevice, String>>();
                        columns.add((IColumn<MfaTrustedDevice, String>)new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
                        columns.add((IColumn<MfaTrustedDevice, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
                        columns.add((IColumn<MfaTrustedDevice, String>)new DatePropertyColumn((IModel)new ResourceModel("recordDate"), "recordDate", "recordDate"));
                        columns.add((IColumn<MfaTrustedDevice, String>)new DatePropertyColumn((IModel)new ResourceModel("expirationDate"), "expirationDate", "expirationDate"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("mfaTrustedDevices", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.DOWN, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                model.setObject((Object)((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).read(((AuthProfileTO)model.getObject()).getKey()));
                target.add(new Component[]{AuthProfileDirectoryPanel.this.authProfileModal.setContent((ModalPanel)new ModalDirectoryPanel(AuthProfileDirectoryPanel.this.authProfileModal, (DirectoryPanel)new AuthProfileItemDirectoryPanel<WebAuthnDeviceCredential>("panel", (AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient, AuthProfileDirectoryPanel.this.authProfileModal, (AuthProfileTO)model.getObject(), AuthProfileDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = 6820212423488933184L;

                    @Override
                    protected List<WebAuthnDeviceCredential> getItems() {
                        return ((AuthProfileTO)model.getObject()).getWebAuthnDeviceCredentials();
                    }

                    @Override
                    protected WebAuthnDeviceCredential defaultItem() {
                        return new WebAuthnDeviceCredential();
                    }

                    @Override
                    protected String sortProperty() {
                        return "identifier";
                    }

                    protected String paginatorRowsKey() {
                        return "authprofile.webAuthnDeviceCredentials.paginator.rows";
                    }

                    protected List<IColumn<WebAuthnDeviceCredential, String>> getColumns() {
                        ArrayList<IColumn<WebAuthnDeviceCredential, String>> columns = new ArrayList<IColumn<WebAuthnDeviceCredential, String>>();
                        columns.add((IColumn<WebAuthnDeviceCredential, String>)new PropertyColumn((IModel)new ResourceModel("identifier"), (Object)"identifier", "identifier"));
                        columns.add((IColumn<WebAuthnDeviceCredential, String>)new PropertyColumn((IModel)new ResourceModel("json"), (Object)"json", "json"));
                        return columns;
                    }
                }, AuthProfileDirectoryPanel.this.pageRef))});
                AuthProfileDirectoryPanel.this.authProfileModal.header((IModel)new Model((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("webAuthnDeviceCredentials", model))));
                AuthProfileDirectoryPanel.this.authProfileModal.show(true);
            }
        }, ActionLink.ActionType.HTML, "AUTH_PROFILE_UPDATE");
        panel.add((ActionLink)new ActionLink<AuthProfileTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, AuthProfileTO ignore) {
                try {
                    ((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).delete(((AuthProfileTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)AuthProfileDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AuthProfileDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    LOG.error("While deleting {}", (Object)((AuthProfileTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BaseWebPage)AuthProfileDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "AUTH_PROFILE_DELETE", true);
        return panel;
    }

    protected final class AuthProfileProvider
    extends DirectoryDataProvider<AuthProfileTO> {
        private static final long serialVersionUID = -185944053385660794L;

        private AuthProfileProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("owner", SortOrder.ASCENDING);
        }

        public Iterator<AuthProfileTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).list((page < 0 ? 0 : page) + 1, this.paginatorRows).iterator();
        }

        public long size() {
            return ((AuthProfileRestClient)AuthProfileDirectoryPanel.this.restClient).count();
        }

        public IModel<AuthProfileTO> model(AuthProfileTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

