/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IOParameterUtil;

public class ErrorEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String errorCode;
    protected List<IOParameter> outParameters;

    public ErrorEndEventActivityBehavior(String errorCode, List<IOParameter> outParameters) {
        this.errorCode = errorCode;
        this.outParameters = outParameters;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
        Map<String, Object> payload = IOParameterUtil.extractOutVariables(this.outParameters, (VariableContainer)execution, expressionManager);
        Object errorMessage = payload.remove("errorMessage");
        BpmnError error = new BpmnError(this.errorCode, errorMessage != null ? errorMessage.toString() : null);
        if (!payload.isEmpty()) {
            error.setAdditionalDataContainer((VariableContainer)new VariableContainerWrapper(payload));
        }
        ErrorPropagation.propagateError(error, execution);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

