/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.db.SingleCachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.CachedEntity;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.variable.service.InternalVariableInstanceQuery;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.data.VariableInstanceDataManager;

public class InternalVariableInstanceQueryImpl
implements InternalVariableInstanceQuery,
CachedEntityMatcher<VariableInstanceEntity>,
SingleCachedEntityMatcher<VariableInstanceEntity> {
    protected final VariableInstanceDataManager dataManager;
    protected String id;
    protected String taskId;
    protected Collection<String> taskIds;
    protected String processInstanceId;
    protected String executionId;
    protected Collection<String> executionIds;
    protected boolean withoutTaskId;
    protected String scopeId;
    protected Collection<String> scopeIds;
    protected String subScopeId;
    protected Collection<String> subScopeIds;
    protected boolean withoutSubScopeId;
    protected String scopeType;
    protected Collection<String> scopeTypes;
    protected String name;
    protected Collection<String> names;

    public InternalVariableInstanceQueryImpl(VariableInstanceDataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public InternalVariableInstanceQuery id(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new FlowableIllegalArgumentException("id is empty");
        }
        this.id = id;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery taskId(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new FlowableIllegalArgumentException("taskId is empty");
        }
        if (this.withoutTaskId) {
            throw new FlowableIllegalArgumentException("Cannot combine taskId(String) with withoutTaskId() in the same query");
        }
        this.taskId = taskId;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery taskIds(Collection<String> taskIds) {
        if (taskIds == null || taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("taskIds is null or empty");
        }
        if (this.withoutTaskId) {
            throw new FlowableIllegalArgumentException("Cannot combine taskIds(Collection) with withoutTaskId() in the same query");
        }
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery processInstanceId(String processInstanceId) {
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            throw new FlowableIllegalArgumentException("processInstanceId is empty");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery executionId(String executionId) {
        if (StringUtils.isEmpty((CharSequence)executionId)) {
            throw new FlowableIllegalArgumentException("executionId is empty");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery executionIds(Collection<String> executionIds) {
        if (executionIds == null || executionIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("executionIds is null or empty");
        }
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery withoutTaskId() {
        if (this.taskId != null || this.taskIds != null) {
            throw new FlowableIllegalArgumentException("Cannot combine withoutTaskId() with task(String) or taskIds(Collection) in the same query");
        }
        this.withoutTaskId = true;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery scopeId(String scopeId) {
        if (StringUtils.isEmpty((CharSequence)scopeId)) {
            throw new FlowableIllegalArgumentException("scopeId is empty");
        }
        this.scopeId = scopeId;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery scopeIds(Collection<String> scopeIds) {
        this.scopeIds = scopeIds;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery subScopeId(String subScopeId) {
        if (StringUtils.isEmpty((CharSequence)subScopeId)) {
            throw new FlowableIllegalArgumentException("subScopeId is empty");
        }
        if (this.withoutSubScopeId) {
            throw new FlowableIllegalArgumentException("Cannot combine subScopeId(String) with withoutSubScopeId() in the same query");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery subScopeIds(Collection<String> subScopeIds) {
        if (this.withoutSubScopeId) {
            throw new FlowableIllegalArgumentException("Cannot combine subScopeIds with withoutSubScopeId in the same query");
        }
        this.subScopeIds = subScopeIds;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery withoutSubScopeId() {
        if (this.subScopeId != null) {
            throw new FlowableIllegalArgumentException("Cannot combine withoutSubScopeId() with subScopeId(String) in the same query");
        }
        this.withoutSubScopeId = true;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery scopeType(String scopeType) {
        if (StringUtils.isEmpty((CharSequence)scopeType)) {
            throw new FlowableIllegalArgumentException("scopeType is empty");
        }
        this.scopeType = scopeType;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery scopeTypes(Collection<String> scopeTypes) {
        this.scopeTypes = scopeTypes;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery name(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new FlowableIllegalArgumentException("name is empty");
        }
        this.name = name;
        return this;
    }

    @Override
    public InternalVariableInstanceQuery names(Collection<String> names) {
        this.names = names;
        return this;
    }

    @Override
    public List<VariableInstanceEntity> list() {
        return this.dataManager.findVariablesInstancesByQuery(this);
    }

    @Override
    public VariableInstanceEntity singleResult() {
        return this.dataManager.findVariablesInstanceByQuery(this);
    }

    public String getId() {
        return this.id;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Collection<String> getTaskIds() {
        return this.taskIds;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Collection<String> getExecutionIds() {
        return this.executionIds;
    }

    public boolean isWithoutTaskId() {
        return this.withoutTaskId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public Collection<String> getScopeIds() {
        return this.scopeIds;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public Collection<String> getSubScopeIds() {
        return this.subScopeIds;
    }

    public boolean isWithoutSubScopeId() {
        return this.withoutSubScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public Collection<String> getScopeTypes() {
        return this.scopeTypes;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getNames() {
        return this.names;
    }

    public InternalVariableInstanceQueryImpl getParameter() {
        return this;
    }

    public boolean isRetained(Collection<VariableInstanceEntity> databaseEntities, Collection<CachedEntity> cachedEntities, VariableInstanceEntity entity, Object param) {
        return this.isRetained(entity, (InternalVariableInstanceQueryImpl)param);
    }

    public boolean isRetained(VariableInstanceEntity entity, Object param) {
        return this.isRetained(entity, (InternalVariableInstanceQueryImpl)param);
    }

    public boolean isRetained(VariableInstanceEntity entity, InternalVariableInstanceQueryImpl param) {
        if (param.executionId != null && !param.executionId.equals(entity.getExecutionId())) {
            return false;
        }
        if (param.scopeId != null && !param.scopeId.equals(entity.getScopeId())) {
            return false;
        }
        if (param.scopeIds != null && !param.scopeIds.contains(entity.getScopeId())) {
            return false;
        }
        if (param.taskId != null && !param.taskId.equals(entity.getTaskId())) {
            return false;
        }
        if (param.processInstanceId != null && !param.processInstanceId.equals(entity.getProcessInstanceId())) {
            return false;
        }
        if (param.withoutTaskId && entity.getTaskId() != null) {
            return false;
        }
        if (param.subScopeId != null && !param.subScopeId.equals(entity.getSubScopeId())) {
            return false;
        }
        if (param.subScopeIds != null && !param.subScopeIds.contains(entity.getSubScopeId())) {
            return false;
        }
        if (param.withoutSubScopeId && entity.getSubScopeId() != null) {
            return false;
        }
        if (param.scopeType != null && !param.scopeType.equals(entity.getScopeType())) {
            return false;
        }
        if (param.scopeTypes != null && !param.scopeTypes.isEmpty() && !param.scopeTypes.contains(entity.getScopeType())) {
            return false;
        }
        if (param.id != null && !param.id.equals(entity.getId())) {
            return false;
        }
        if (param.taskIds != null && !param.taskIds.contains(entity.getTaskId())) {
            return false;
        }
        if (param.executionIds != null && !param.executionIds.contains(entity.getExecutionId())) {
            return false;
        }
        if (param.name != null && !param.name.equals(entity.getName())) {
            return false;
        }
        return param.names == null || param.names.isEmpty() || param.names.contains(entity.getName());
    }
}

