;; Scheduling description for IBM PowerPC 440 processor.
;;   Copyright (C) 2003-2023 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; PPC440 Embedded PowerPC controller
;; dual issue
;; i_pipe - complex integer / compare / branch
;; j_pipe - simple integer arithmetic
;; l_pipe - load-store
;; f_pipe - floating point arithmetic

(define_automaton "ppc440_core,ppc440_apu")
(define_cpu_unit "ppc440_i_pipe,ppc440_j_pipe,ppc440_l_pipe" "ppc440_core")
(define_cpu_unit "ppc440_f_pipe" "ppc440_apu")
(define_cpu_unit "ppc440_issue_0,ppc440_issue_1" "ppc440_core")

(define_reservation "ppc440_issue" "ppc440_issue_0|ppc440_issue_1")


(define_insn_reservation "ppc440-load" 3
  (and (eq_attr "type" "load,load_l,store_c,sync")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-store" 3
  (and (eq_attr "type" "store")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-integer" 1
  (and (ior (eq_attr "type" "integer,insert,trap,cntlz,isel")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "no")))
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue_0+ppc440_issue_1,\
   ppc440_i_pipe|ppc440_j_pipe,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue_0+ppc440_issue_1,ppc440_i_pipe|ppc440_j_pipe,\
   ppc440_i_pipe|ppc440_j_pipe,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-imul" 3
  (and (eq_attr "type" "mul")
       (eq_attr "size" "32")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-imul2" 2
  (and (ior (eq_attr "type" "halfmul")
	    (and (eq_attr "type" "mul")
		 (eq_attr "size" "8,16")))
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-idiv" 34
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe*33")

(define_insn_reservation "ppc440-branch" 1
  (and (eq_attr "type" "branch,jmpreg,isync")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-compare" 2
  (and (ior (eq_attr "type" "cmp,cr_logical,mfcr")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "yes")))
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-fpcompare" 3 ; 2
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe+ppc440_i_pipe")

(define_insn_reservation "ppc440-fp" 5
  (and (eq_attr "type" "fp,fpsimple,dmul")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe")

(define_insn_reservation "ppc440-sdiv" 19
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe*15")

(define_insn_reservation "ppc440-ddiv" 33
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe*29")

(define_insn_reservation "ppc440-mtcr" 3
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-mtjmpr" 4
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

