;; Pipeline description for Motorola PowerPC e500mc core.
;;   Copyright (C) 2008-2024 Free Software Foundation, Inc.
;;   Contributed by Edmar Wienskoski (edmar@freescale.com)
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; e500mc 32-bit SU(2), LSU, FPU, BPU
;; Max issue 3 insns/clock cycle (includes 1 branch)
;; FP is half clocked, timings of other instructions are as in the e500v2.

(define_automaton "e500mc_most,e500mc_long,e500mc_retire")
(define_cpu_unit "e500mc_decode_0,e500mc_decode_1" "e500mc_most")
(define_cpu_unit "e500mc_issue_0,e500mc_issue_1"   "e500mc_most")
(define_cpu_unit "e500mc_retire_0,e500mc_retire_1" "e500mc_retire")

;; SU.
(define_cpu_unit "e500mc_su0_stage0,e500mc_su1_stage0" "e500mc_most")

;; MU.
(define_cpu_unit "e500mc_mu_stage0,e500mc_mu_stage1" "e500mc_most")
(define_cpu_unit "e500mc_mu_stage2,e500mc_mu_stage3" "e500mc_most")

;; Non-pipelined division.
(define_cpu_unit "e500mc_mu_div" "e500mc_long")

;; LSU.
(define_cpu_unit "e500mc_lsu" "e500mc_most")

;; FPU.
(define_cpu_unit "e500mc_fpu" "e500mc_most")

;; Branch unit.
(define_cpu_unit "e500mc_bu" "e500mc_most")

;; The following units are used to make the automata deterministic.
(define_cpu_unit "present_e500mc_decode_0" "e500mc_most")
(define_cpu_unit "present_e500mc_issue_0" "e500mc_most")
(define_cpu_unit "present_e500mc_retire_0" "e500mc_retire")
(define_cpu_unit "present_e500mc_su0_stage0" "e500mc_most")

;; The following sets to make automata deterministic when option ndfa is used.
(presence_set "present_e500mc_decode_0" "e500mc_decode_0")
(presence_set "present_e500mc_issue_0" "e500mc_issue_0")
(presence_set "present_e500mc_retire_0" "e500mc_retire_0")
(presence_set "present_e500mc_su0_stage0" "e500mc_su0_stage0")

;; Some useful abbreviations.
(define_reservation "e500mc_decode"
    "e500mc_decode_0|e500mc_decode_1+present_e500mc_decode_0")
(define_reservation "e500mc_issue"
    "e500mc_issue_0|e500mc_issue_1+present_e500mc_issue_0")
(define_reservation "e500mc_retire"
   "e500mc_retire_0|e500mc_retire_1+present_e500mc_retire_0")
(define_reservation "e500mc_su_stage0"
   "e500mc_su0_stage0|e500mc_su1_stage0+present_e500mc_su0_stage0")

;; Simple SU insns.
(define_insn_reservation "e500mc_su" 1
  (and (eq_attr "type" "integer,add,logical,insert,cmp,\
                        shift,trap,cntlz,exts,isel")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su_stage0+e500mc_retire")

(define_insn_reservation "e500mc_two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su_stage0+e500mc_retire,\
   e500mc_issue+e500mc_su_stage0+e500mc_retire")

(define_insn_reservation "e500mc_three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su_stage0+e500mc_retire,\
   e500mc_issue+e500mc_su_stage0+e500mc_retire,\
   e500mc_issue+e500mc_su_stage0+e500mc_retire")

;; Multiply.
(define_insn_reservation "e500mc_multiply" 4
  (and (eq_attr "type" "mul")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_mu_stage0,e500mc_mu_stage1,\
   e500mc_mu_stage2,e500mc_mu_stage3+e500mc_retire")

;; Divide. We use the average latency time here.
(define_insn_reservation "e500mc_divide" 14
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_mu_stage0+e500mc_mu_div,\
   e500mc_mu_div*13")

;; Branch.
(define_insn_reservation "e500mc_branch" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_bu,e500mc_retire")

;; CR logical.
(define_insn_reservation "e500mc_cr_logical" 1
  (and (eq_attr "type" "cr_logical")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_bu,e500mc_retire")

;; Mfcr.
(define_insn_reservation "e500mc_mfcr" 1
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su1_stage0+e500mc_retire")

;; Mtcrf.
(define_insn_reservation "e500mc_mtcrf" 1
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su1_stage0+e500mc_retire")

;; Mtjmpr.
(define_insn_reservation "e500mc_mtjmpr" 1
  (and (eq_attr "type" "mtjmpr,mfjmpr")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_su_stage0+e500mc_retire")

;; Loads.
(define_insn_reservation "e500mc_load" 3
  (and (eq_attr "type" "load,load_l,sync")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_lsu,nothing,e500mc_retire")

(define_insn_reservation "e500mc_fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_lsu,nothing*2,e500mc_retire")

;; Stores.
(define_insn_reservation "e500mc_store" 3
  (and (eq_attr "type" "store,store_c")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_lsu,nothing,e500mc_retire")

(define_insn_reservation "e500mc_fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_lsu,nothing,e500mc_retire")

;; The following ignores the retire unit to avoid a large automata.

;; Simple FP.
(define_insn_reservation "e500mc_simple_float" 8
  (and (eq_attr "type" "fpsimple")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu")
; "e500mc_decode,e500mc_issue+e500mc_fpu,nothing*6,e500mc_retire")

;; FP.
(define_insn_reservation "e500mc_float" 8
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu")
; "e500mc_decode,e500mc_issue+e500mc_fpu,nothing*6,e500mc_retire")

(define_insn_reservation "e500mc_fpcompare" 8
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu")

(define_insn_reservation "e500mc_dmul" 10
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu")

;; FP divides are not pipelined.
(define_insn_reservation "e500mc_sdiv" 36
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu,e500mc_fpu*35")

(define_insn_reservation "e500mc_ddiv" 66
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppce500mc"))
  "e500mc_decode,e500mc_issue+e500mc_fpu,e500mc_fpu*65")
